﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace IndexCorrelation
{
    static class Program
    {
        static void Main(string[] args)
        {
            List<Index> indicesDataLst = new List<Index>();
            List<string> indicesNameLst = new List<string>();
            List<Relation> indicesRelLst = new List<Relation>();
            List<AvgRelation> indicesAvgRelLst = new List<AvgRelation>();
            Console.WriteLine("输入CSV文件名：");
            string fileName = Console.ReadLine();
            using (var reader = new StreamReader(@".\"+fileName))
            {
                string headLine = reader.ReadLine();
                int columnCount = headLine.Split(',').Length;
                for(int i = 1;i<columnCount;i++)
                {
                    indicesDataLst.Add(new Index(headLine.Split(',')[i]));
                }
                while (!reader.EndOfStream)
                {
                    var line = reader.ReadLine();
                    var values = line.Split(',');
                    for (int i = 1; i < columnCount; i++)
                    {
                        indicesDataLst[i-1].Price.Add(Convert.ToDouble(values[i]));
                    }
                }
            }
            Console.WriteLine("已读取到以下数据：");
            foreach (var item in indicesDataLst)
            {
                indicesNameLst.Add(item.Name);
                Console.WriteLine(item.Name);
            }
            IEnumerable<IEnumerable<String>> result = Combinations(indicesNameLst, 2);
            foreach (var item in result)
            {
                double coff = 0;
                List<double> a = indicesDataLst.Find(i => i.Name.Equals(item.ToList()[0])).Price;
                List<double> b = indicesDataLst.Find(i => i.Name.Equals(item.ToList()[1])).Price;
                Correl(a.ToArray(), b.ToArray(), ref coff);
                indicesRelLst.Add(new Relation(item.ToList()[0], item.ToList()[1], coff));
            }
            Console.WriteLine("输入每个无顺序不重复的组合中的元素个数：");
            int combNum = Convert.ToInt32(Console.ReadLine());
            result = Combinations(indicesNameLst, combNum);
            Console.WriteLine("共产生" + result.Count() + "个组合");
            foreach (var item in result)
            {
                AvgRelation avgRelation = new AvgRelation();
                avgRelation.ObjList.AddRange(item.ToList());
                indicesAvgRelLst.Add(avgRelation);
            }
            foreach (var item in indicesAvgRelLst)
            {
                for (int i = 0 ; i < (item.ObjList.Count-1); i++)
                {
                    for (int j = i+1; j < item.ObjList.Count; j++)
                    {
                        item.RelationLst.Add(indicesRelLst.Find(s => s.FirstObj.Equals(item.ObjList[i]) &&
                            s.SecondObj.Equals(item.ObjList[j])).Coefficient);
                    }
                }
            }
            Console.WriteLine("计算中。。。组合越多，计算越久");
            indicesAvgRelLst.Sort();
            Console.WriteLine("按平均相关性从小到大，输出几个组合？");
            int showNum = Convert.ToInt32(Console.ReadLine());
            if (showNum > indicesAvgRelLst.Count)
            {
                Console.WriteLine("输入元素太多，全部输出");
                showNum = indicesAvgRelLst.Count;
            }
            for (int i = 0; i < showNum; i++)
            {
                for (int j = 0; j < indicesAvgRelLst[i].ObjList.Count; j++)
                {
                    Console.Write(indicesAvgRelLst[i].ObjList[j].ToString() + " ");
                }
                Console.Write("平均相关性：" + (indicesAvgRelLst[i].AvgCoff*100).ToString("0.0000") + "%");
                Console.WriteLine();
            }
            Console.WriteLine("查询包含输入指数的组合，以空格分隔，回车结束");
            string[] searchArray = Console.ReadLine().Split(' ');
            int indexNum = searchArray.Count();
            List<AvgRelation> searchList = indicesAvgRelLst.FindAll(c => c.ObjList.Contains(searchArray[0]));
            for (int i = 1; i < indexNum; i++)
            {
                searchList = searchList.FindAll(c => c.ObjList.Contains(searchArray[i]));
            }
            foreach (var item in searchList)
            {
                for (int j = 0; j < item.ObjList.Count; j++)
                {
                    Console.Write(item.ObjList[j].ToString() + " ");
                }
                Console.Write("平均相关性：" + (item.AvgCoff*100).ToString("0.0000") + "%");
                Console.WriteLine();
            }
            Console.ReadKey();
        }

        public static IEnumerable<IEnumerable<T>> Combinations<T>(this IEnumerable<T> elements, int k)
        {
            return k == 0 ? new[] { new T[0] } :
              elements.SelectMany((e, i) =>
                elements.Skip(i + 1).Combinations(k - 1).Select(c => (new[] { e }).Concat(c)));
        }

        static bool Correl(double[] x, double[] y, ref double coff)
        {
            if (x.Length != y.Length)
            {
                return false;
            }
            if(x.Length == 0 || y.Length == 0)
            {
                return false;
            }
            double stdDevX = 0;
            double avgX = x.Average();
            foreach (var item in x)
            {
                stdDevX += Math.Pow(item - avgX, 2);
            }
            double stdDevY = 0;
            double avgY = y.Average();
            foreach (var item in y)
            {
                stdDevY += Math.Pow(item - avgY, 2);
            }
            if(stdDevX == 0 || stdDevY == 0)
            {
                return false;
            }
            for(int i = 0;i<x.Length;i++)
            {
                coff += ((x[i] - avgX) * (y[i] - avgY));
            }
            coff = coff / Math.Sqrt(stdDevX * stdDevY);
            return true;
        }
    }
}
